/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.hyperlink;

import com.aptana.console.AdaptingHyperlink;
import com.aptana.core.logging.IdeLog;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.hyperlink.HyperlinkDetector;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class GitConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole fConsole;
    private HyperlinkDetector detector;

    public void init(IConsole console) {
        this.fConsole = console;
        this.detector = new HyperlinkDetector();
    }

    public void lineAppended(IRegion line) {
        try {
            String lineContents = this.fConsole.getDocument().get(line.getOffset(), line.getLength());
            IHyperlink[] links = this.detector.detectHyperlinks(lineContents);
            if (links != null) {
                IHyperlink[] iHyperlinkArray = links;
                int n = links.length;
                int n2 = 0;
                while (n2 < n) {
                    IHyperlink link = iHyperlinkArray[n2];
                    this.fConsole.addLink((org.eclipse.ui.console.IHyperlink)new AdaptingHyperlink(link), line.getOffset() + link.getHyperlinkRegion().getOffset(), link.getHyperlinkRegion().getLength());
                    ++n2;
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
    }

    public void dispose() {
        this.detector = null;
        this.fConsole = null;
    }
}

